
DESCRIPTION OF THE GAP TEST

Introduction
------------

As the name implies, the gap test considers intervals between
a and b inclusive, where 0 <= a < b <= 1, in which random
numbers fail to appear.  Pictorially, suppose a and b are
situated like this:

	0	a	b	1
	|-------|-------|-------|

The gap test scans for sequences in which all numbers fall
_outside_ a and b.  The length of the sequence is the number
of variates found.  A count is maintained of the number of
times each such length occurs.  Thus, COUNT[0] contains the
number of times that a gap of length 0 occurred, COUNT[1],
the number of times that a gap length 1 occurred and so on.

The probability of an occurrence of a gap of length i, for
0 <= i <= t is:

    p[0] = p = (b-a)                                            | The [] denote
    p[1] = p(1-p)   p[2] = p(1-p)^2  ... p[t-1] = p(1-p)^(t-1)  | subscripts,
    p[t] = (1-p)^t                                              | The ^ denote
								| exponents
This is the only test that is controlled by the interval from
0 to 1.  All other tests are concerned with integers ranging
from 0 to 32767 which is the range of values produced by the
standard C library function, rand().

Running the Gap Test
--------------------

To start program gaptst, you can say simply

	gaptst

and you will be prompted for the required inputs.

Alternatively, you can say

	gaptst < [myfile.inp]

and the program will take its input data from myfile.inp.

Seven input parameters are required:

    1.  Seed for the random number generator (-1 = Time of day)

       	If you do not specify -1, the value entered must be less
	than 65536.

    2.  Specification of generator to be tested

    	If you are working interactively, you will see a list
       	of the generators that can be selected.  You enter the
	character that represents your generator.  If you enter
	a character that is not in the list, the library rand()
	function will be used.

    3.  Lower boundary (a) of gap, 0 <= a < 1

	This sets the lower limit of the search.  This number
	is converted to an integer between 0 and 32767.

    4.  Upper boundary (b) of gap, a < b <= 1

	This number must be greater than a.  It should also
	be greater than a by at least .01.  If you specify
	boundaries that are closer than that you are in for
	a long wait because each iteration will require an
	exorbitant number of variates.  For example, when
	a = .01 and b = .011, about five million variates
	are required per pass.  The total number of variates
	needed would be in the neighborhood of 500,000,000.

    5.  Maximum gap length desired (number of variates)

	Gap lengths greater than this number are lumped into
	one category.  All others are counted separately.

    6.  Minimum cell expectation (counts per category)

	This entry specifies the minimum number of counts
	that you expect per gap length tallied.  If you
	specify a number less than five, the number is set
	to five (clamped).

    7.  Number of gaps to be tabulated (counted)

	The minimum number that program gaptst will use will
	be specified in the prompt.  This number is a function
	of gap limit (a, b), the maximum gap length and the
	minimum cell expectation.

Execution of the Algorithm
--------------------------

Once the input parameters have been processes and run-control
variables have been set, the program will execute 100 chi-square
runs as dictated by the input:

    1.	The generator of choice is called the number of times set by
	input parameter 7 above. The cell (or category) corresponding
	to the length of each gap is tallied.

    2.  A chi-square statistic is calculated for the array of tallies.

    3.	A probability for the chi-square statistic is calculated.

    4.	The probability is stored in an array.

    5.	A running account of the steps and the number of variates
	generated lets you know that the program is executing.

When the 100 runs are complete, a Kolmogorov-Smirnov test is run on
the array to obtain statistics Kn+ and Kn- and their corresponding
probabilities.

Final printouts consist of the Kolmogorov-Smirnov statistics and
probabilities and the number of random numbers generated during the
test.

Figure.1g shows a sample input file should you elect to redirect the
input.  Figure.2g shows what you can expect to see if you redirect the
output during the run on the sample input shown in figure 1g.  Figure.3g
shows what your screen should look like if you redirect stdout to a file.

Error Printouts
---------------

 *  Gap Boundaries Improperly Specified

    o You Have Specified Gap Limits 0 and 1. Please Reenter.

    o The Difference Between the Lower Boundary (0.01) and the
      Upper Boundary (0.01001) is not Great Enough (0.00001)
      You should specify limits that differ by .005 or more.

Timing Estimates
----------------

The run shown in figure 1.g required about 5.9 seconds on my
Pentium 100.  Naturally, the time required depends on the
generator (and the CPU).  For the data shown above, the range
of times is from 5.9 seconds for the MSC library function rand()
to 35.3 seconds for the generator by Stephen L. Moshier.  Both
tests required about 4,096,000 random numbers.
